/**
* \file: AilAudioSink.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Android Auto
*
* \author: I. Hayashi / ADITJ/SW / ihayashi@jp.adit-jv.com
*          J. Michalik / ADITG/SW1 / jmichalik@de.adit-jv.com
*
* \copyright (c) 2016-2017 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef AAUTO_AILAUDIOSINK_H
#define AAUTO_AILAUDIOSINK_H

#include "aauto/AditAudioSink.h"

namespace adit { namespace aauto {

/* forward declaration of internal implementation */
class AilAudioSinkImpl;

/** 
 * @brief AilAudioSink provides AIL specific audio sink implementation.*/
class AilAudioSink : public AditAudioSink
{
public:
    /**
     * @brief  Constructor of AilAudioSink
     * @param  inSessionId      inSessionId is Id that is used in GalReceiver as identification data on session.
     * @param  inMessageRouter  inMessageRouter is message router obtained from GalReceiver. */
    AilAudioSink(uint8_t inSessionId, MessageRouter* inMessageRouter);
    virtual ~AilAudioSink();

    /**
     * @brief Initialize the AilAudioSink. All configuration items must be set.
     *
     * @return true if initialization succeeds.
     *          false if configuration items without default value is not set or initialization
     *          fails. */
    bool init();

    /**
     * @brief  Shutdown the AIL Audio Sink */
    void shutdown();

    /** @brief Set configuration for platform and AudioSink-related items. Must be called before init().
     * @param  inKey        The key string for configuration (e.g. "audio-capture-device")
     * @param  inValue      The actual value for configuration (e.g. "device=Entertainment periodMs=8")
     * */
    void setConfigItem(string inKey, string inValue);

    /**
     * @brief Register callback interface to receive AudioSink-related notifications.
     * See IAditAudioSinkCallbacks for details.
     *
     * @param   inCallbacks object implementing the callback interface */
    void registerCallbacks(IAditAudioSinkCallbacks* inCallbacks);

private:
    AilAudioSinkImpl* impl;
};

} } /* namespace adit { namespace aauto { */

#endif /* AAUTO_AILAUDIOSINK_H */
